﻿namespace Microsoft.Samples.PlanMyNight.Web
{
    using System;
    using System.ComponentModel.Composition.Hosting;
    using System.ComponentModel.Composition.Primitives;
    using System.Configuration;
    using System.IO;
    using System.Security.Principal;
    using System.Web;
    using System.Web.Mvc;
    using System.Web.Routing;
    using System.Web.Security;
    using Microsoft.Samples.PlanMyNight.Data;
    using Microsoft.Samples.PlanMyNight.Data.Caching;
    using Microsoft.Samples.PlanMyNight.Infrastructure;
    using Microsoft.Samples.PlanMyNight.Web.Infrastructure;
    using Microsoft.Samples.Web.MobileCapableViewEngine;

    public class MvcApplication : System.Web.HttpApplication
    {
        protected void Application_Start()
        {
            // Caching Provider
            var cachingProviderTypeAssembly = ConfigurationManager.AppSettings["Caching.Provider"].Split(',');
            var cachingProviderInstance = (ICachingProvider)Activator.CreateInstance(cachingProviderTypeAssembly[1], cachingProviderTypeAssembly[0], null).Unwrap();
            var cachingProviderType = cachingProviderInstance.GetType();

            // Addins catalog
            var addinsCatalog = new AddinsDirectoryCatalog(Path.Combine(HttpRuntime.AppDomainAppPath, @"Areas"));

            // Type Catalogs
            var catalog = new AggregateCatalog(
                new ComposablePartCatalog[] {
                    new TypeCatalog(new Type[] { typeof(ServiceFactory) }),
                    addinsCatalog
                });

            var container = new CompositionContainer(catalog, true);
            ServiceLocator.SetLocatorProvider(() => container);

            // MEF Controller factory
            var controllerFactory = new MefControllerFactory(container);
            ControllerBuilder.Current.SetControllerFactory(controllerFactory);

            // Register routes from Addins
            foreach (RouteCollection routes in container.GetExportedValues<RouteCollection>())
            {
                foreach (var route in routes)
                {
                    RouteTable.Routes.Add(route);
                }
            }

            // Continue with Default controllers and navigation nodes. Should be replaced to use MEF all along
            RoutingManager.RegisterRoutes(RouteTable.Routes);

            // View Engine for Mobile 
            var engine = new MobileCapableWebFormViewEngine();
            engine.DeviceFolders.Clear();
            engine.DeviceFolders.Add("Pocket IE", "WindowsMobile");
            ViewEngines.Engines.Clear();
            ViewEngines.Engines.Add(engine);
        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {
            var cookieName = FormsAuthentication.FormsCookieName;
            var cookie = Context.Request.Cookies[cookieName];
            if (cookie == null) return;
            FormsAuthenticationTicket ticket = null;
            try
            {
                ticket = FormsAuthentication.Decrypt(cookie.Value);
                if (ticket != null)
                {
                    var identity = new FormsIdentity(ticket);
                    var principal = new GenericPrincipal(identity, new[] { "user" });
                    this.Context.User = principal;
                }
            }
            catch
            {
            }
        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {
            var url = HttpContext.Current.Request.Url;
            var authority = HttpContext.Current.Request.ServerVariables["HTTP_HOST"];
            var expectedAuthority = url.Port == 48580 ? "www.planmynight.net:48580" : "planmynight.net";
            var pathAndQuery = url.PathAndQuery;
            if (pathAndQuery == "/default.aspx")
            {
                pathAndQuery = "/";
            }

            if (!authority.Equals(expectedAuthority, StringComparison.OrdinalIgnoreCase))
            {
                var redirectTo = string.Concat(url.Scheme, "://", expectedAuthority, pathAndQuery);
                Response.RedirectPermanent(redirectTo);
            }
        }
    }
}